require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require_relative '../rspec_helper'
require_relative '../../pages/community_care/community_Care_PageObject'
require 'rubygems'
require_relative '../../module/DriverUtility'

describe '[Story VAR-10006 :CC Request - Provider Preferences - Include up to three preferred providers', :varList_MockService => false do
  include DriverUtility
  include DateUtility
  include OracleUtility
  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @cc_po = CommunityCare_PageObject.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    deletePatientData("1113138327")
    deleteNotificationPreference("1113138327")
    @today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    @todayhr = getNthHoursFromNow(0)
    @todaymin = getNthMinFromNow(0)
    @ninteenDaysLater = getDateNthDaysFromNow(19, "%m/%d/%Y")
    @fiveDaysLater = getDateNthDaysFromNow(5,"%m/%d/%Y")
    @sevenDaysLater = getDateNthDaysFromNow(7,"%m/%d/%Y")
    @cc_po.common.loginEndsOnHome(pw_redacted)
    @cc_po.common.selectAddAppointmentButton("CC")
  end

  after(:all) do
    @cc_po.loginLogout.logout
  end

  context "AC#11279|TC#11280:CC Request - Provider Preferences - Include up to three preferred providers" do
    it "Login and navigate to Provider Preference wizard" do
      @cc_po.communityCare.distanceElibleVeteran("yes")
      @cc_po.communityCare.clickContinueButton
      @cc_po.communityCare.selectLocation("BOSTON HCS VAMC")
      @cc_po.communityCare.selectTypeOfCare("Optometry (routine eye exam)")
      @cc_po.communityCare.con_yes_element.click
      @cc_po.communityCare.clickContinueButton
      @cc_po.communityCare.choice1_date = @ninteenDaysLater
      @cc_po.communityCare.radio_am_pm_elements[1].click
      @cc_po.communityCare.choice2_date = @fiveDaysLater
      @cc_po.communityCare.radio_am_pm_elements[3].click
      @cc_po.communityCare.choice3_date = @sevenDaysLater
      @cc_po.communityCare.radio_am_pm_elements[4].click
      @cc_po.communityCare.clickContinueButton
      @cc_po.communityCare.provider_city_element.when_present(TIME_OUT_LIMIT)
      expect((@cc_po.communityCare.step_heading_element.text).gsub(/\n+/, ' ')).to eq("Step 6: Provider Preferences")
    end


    it "Verify Preferred provider section labels" do
      @cc_po.communityCare.provideLocationDetails("Dulles", "VA", "20166", "10", "Chinese", "all")
      @cc_po.communityCare.preferred_providers_all_fields_element.when_present(TIME_OUT_LIMIT)
      actual_content = @cc_po.communityCare.preferred_providers_all_fields_element.text.split("\n")
      expected_content = [\
      "Preferred Providers",
      "You may indicate up to three providers. Please visit our Veteran Choice Locator to find a provider on our approved list.",
      "Provider Choice #1",
      "First Name",
      "Last Name",
      "Practice Name",
      "Street Address",
      "City",
      "State","Select","AL","AK","AR","AS","AZ","CA","CO","CT","DE","DC", "FL", "GA", "GU", "HI", "ID", "IL", "IN", "IA", "KS", "KY", "LA", "ME", "MD", "MA", "MI", "MN", "MS", "MO", "MT", "NE", "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "MP", "OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN", "TX", "UT", "VI", "VT", "VA", "WA", "WV", "WI", "WY",
      "ZIP Code",
      "+ Add Provider"
      ]
      compareContents(expected_content, actual_content)
    end

    it "Verify Add Provider button fucntionality and Provider-2 fields/texts" do
      @cc_po.communityCare.clickAddProvider
      @cc_po.communityCare.primary_provider_2_fields_element.when_present(TIME_OUT_LIMIT)
      actual_content = @cc_po.communityCare.primary_provider_2_fields_element.text.split("\n")
      expected_content = [\
      "Provider Choice #2",
      "First Name",
      "Last Name",
      "Practice Name",
      "Street Address",
      "City",
      "State","Select","AL","AK","AR","AS","AZ","CA","CO","CT","DE","DC", "FL", "GA", "GU", "HI", "ID", "IL", "IN", "IA", "KS", "KY", "LA", "ME", "MD", "MA", "MI", "MN", "MS", "MO", "MT", "NE", "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "MP", "OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN", "TX", "UT", "VI", "VT", "VA", "WA", "WV", "WI", "WY",
      "ZIP Code",
      "Delete",
      "+ Add Provider"
      ]
      compareContents(expected_content, actual_content)
    end

    it "Verify Add Provider button fucntionality and Provider-3 fields/texts" do
      button_element = @driver.button(:css => '.primary-provider2 #add-provider')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @cc_po.communityCare.primary_provider_3_fields_element.when_present(TIME_OUT_LIMIT)
      actual_content = @cc_po.communityCare.primary_provider_3_fields_element.text.split("\n")
      expected_content = [\
      "Provider Choice #3",
      "First Name",
      "Last Name",
      "Practice Name",
      "Street Address",
      "City",
      "State","Select","AL","AK","AR","AS","AZ","CA","CO","CT","DE","DC", "FL", "GA", "GU", "HI", "ID", "IL", "IN", "IA", "KS", "KY", "LA", "ME", "MD", "MA", "MI", "MN", "MS", "MO", "MT", "NE", "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "MP", "OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN", "TX", "UT", "VI", "VT", "VA", "WA", "WV", "WI", "WY",
      "ZIP Code",
      "Delete"
      ]
      compareContents(expected_content, actual_content)
    end

    it "Verify Addition Appointment Preferences field" do
      @cc_po.communityCare.additional_appt_preferences_field_element.when_present(TIME_OUT_LIMIT)
      expect(@cc_po.communityCare.additional_appt_preferences_field_element.text).to eq "Other Provider Preferences\n(250 char limit)\n250 characters remaining"
    end

    it "Verify user can delete a provider section" do
      button_element = @driver.button(:css => 'button[id=\'3\']')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @driver.element(:css=>'.primary-provider1 #add-provider').when_present(TIME_OUT_LIMIT)
      sleep 2
      expect(@cc_po.communityCare.provider_3_header_element.visible?).to eq(false)
    end

    it "Verify Deleting a previous provider section will re arrange Provided preference" do
      button_element = @driver.button(:css => '.primary-provider2 #add-provider')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @cc_po.communityCare.primary_provider_3_fields_element.when_present(TIME_OUT_LIMIT)
      button_element = @driver.button(:css => 'button[id=\'2\']')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @driver.element(:css=>'.primary-provider1 #add-provider').when_present(TIME_OUT_LIMIT)
      sleep 2
      expect(@cc_po.communityCare.provider_3_header_element.visible?).to eq(false)
    end

  end

end
